<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Karyawan;
use App\Models\Absensi;
use App\Models\Gaji;
use Carbon\Carbon;

class DashboardController extends Controller
{
    public function index()
    {
        $today = Carbon::today();
        $bulanIni = Carbon::now()->month;
        $tahunIni = Carbon::now()->year;

        // Total karyawan aktif
        $totalKaryawan = Karyawan::where('status', 'aktif')->count();

        // Absensi hari ini
        $absensiHariIni = Absensi::whereDate('tanggal', $today)->count();
        $hadirHariIni = Absensi::whereDate('tanggal', $today)
            ->whereIn('status', ['hadir', 'terlambat'])
            ->count();
        $terlambatHariIni = Absensi::whereDate('tanggal', $today)
            ->where('status', 'terlambat')
            ->count();

        // Statistik bulan ini
        $totalAbsensiBulanIni = Absensi::whereMonth('tanggal', $bulanIni)
            ->whereYear('tanggal', $tahunIni)
            ->count();

        // Recent absensi
        $recentAbsensi = Absensi::with('karyawan')
            ->whereDate('tanggal', $today)
            ->orderBy('created_at', 'desc')
            ->limit(10)
            ->get();

        return view('admin.dashboard', compact(
            'totalKaryawan',
            'absensiHariIni',
            'hadirHariIni',
            'terlambatHariIni',
            'totalAbsensiBulanIni',
            'recentAbsensi'
        ));
    }
}
